/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class MasterfulStab
extends AbstractCard {
    public static final String ID = "Masterful Stab";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Masterful Stab");
    public static final String NAME = MasterfulStab.cardStrings.NAME;
    public static final String DESCRIPTION = MasterfulStab.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = MasterfulStab.cardStrings.UPGRADE_DESCRIPTION;
    private static final int DAMAGE = 15;
    private static final int COST = 0;
    private static final int POOL = 1;

    public MasterfulStab() {
        super(ID, NAME, "green/attack/masterfulStab", "green/attack/masterfulStab", 0, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.baseDamage = 15;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.SLASH_HEAVY));
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        boolean canUse = super.canUse(p, m);
        if (!canUse) {
            return false;
        }
        if (p.hand.size() != 1) {
            canUse = false;
            this.cantUseMessage = UPGRADE_DESCRIPTION;
        }
        return canUse;
    }

    @Override
    public AbstractCard makeCopy() {
        return new MasterfulStab();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(5);
        }
    }
}

